package music;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ReadOnlyBufferException;

/**
 * Write a description of class Performer here.
 *
 * @author (your name)
 * @version (a version number or a date)
 */

public class Performer extends Musician implements Serializable {
    private String name;
    private int age;
    private String origin;
    private String genre;
    
    private static final long serialVersionUID = 76L;
    
    public Performer(String name, int age, String origin, String genre) {
        this.name = name;
        this.age = age;
        this.origin = origin;
        this.genre = genre;
    }
    
    public Performer(String name, int age, String origin) {
        this.name = name;
        this.age = age;
        this.origin = origin;
    }
    
    public Performer() {
    }
    
    public void serialize(String filename) {
    	try {
			ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(filename)));
			out.writeObject(this);
			out.flush();
			out.close();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }
    
    public static Performer deserialize(String filename) {
    	Performer p = null;
    	try {
			ObjectInputStream in = new ObjectInputStream(new FileInputStream(new File(filename)));
			p = (Performer) in.readObject();
			in.close();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    	return p;
    }
    
	@Override
	public void describe() {
		System.out.println("Performer");
	}
    @Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + age;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		result = prime * result + ((origin == null) ? 0 : origin.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Performer other = (Performer) obj;
		if (age != other.age)
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		if (origin == null) {
			if (other.origin != null)
				return false;
		} else if (!origin.equals(other.origin))
			return false;
		return true;
	}
	
	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return this.name + ", (" + this.age + "), " + this.origin + "; " + this.genre;
	}

	public void setName(String name) {
        this.name = name;
        // name = name;
    }
    
    public String getName() {
        return this.name;
        // return name;
    }
    
    public void setAge(int age) {
        this.age = age;
    }
    
    public int getAge() {
        return this.age;
    }
    
    public void setOrigin(String origin) {
        this.origin = origin;
    }
    
    public String getOrigin() {
        return this.origin;
    }

	@Override
	public void setGenre(String genre) {
		this.genre = genre;
	}

	@Override
	public String getGenre() {
		return this.genre;
	}

}
